use "${tmp}/main_labex_with_ctrf", clear


forvalues i = 19(1)35 {
	egen false_pos`i' = sum(!accept*(note_totale >= `i'))
	egen true_pos`i' = sum(accept*(note_totale >= `i'))
	 egen false_neg`i' = sum(accept*(note_totale < `i'))
	egen true_neg`i' = sum(!accept*(note_totale < `i'))
	gen foo = note_totale>=`i'
	reg accept foo
	drop foo
	gen R2`i' = e(r2_a)
}

keep false_pos* true_pos* false_neg* true_neg* R2*
gduplicates drop
gen n = 1


reshape long false_pos true_pos false_neg true_neg R2, i(n) j(ival) string
destring ival, replace

gen precision = true_pos / (true_pos + false_pos)
gen recall = true_pos / (true_pos + false_neg)
gen F1 = 2*(precision*recall) / (precision+recall)
gen youden_J = true_pos/(true_pos+false_neg) + true_neg / (true_neg + false_pos) - 1

twoway connected F1 R2 youden  ival if inrange(ival, 21, 35), legend(label(1 "F1 score") label(2 "R Squared") label(3 "Youden-J") rows(1) pos(6)) yscale(fextend) xscale(fextend) xlab(21(1)35, nogrid) xtitle("") ytitle("Index") xline(30) ylab(, nogrid)
graph export  "${outpath}/FigureB4.pdf", as(pdf) replace
